/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.param.parser.CLOption;
import oracle.ops.verification.framework.param.parser.CLOptionEnumItem;
import oracle.ops.verification.framework.param.parser.CLOptionSelection;
import oracle.ops.verification.framework.param.parser.CLSyntax2;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CLCommand {
    private static final int LIST_LHS_DISPLAY_LENGTH = 15;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    protected String m_name = null;
    protected CLOptionSelection m_selection = null;
    protected List<CLOption> m_optionList = null;
    protected String m_valueType = null;
    protected boolean m_valueRequired = false;
    protected List<CLOptionEnumItem> m_valueList = null;
    protected boolean m_required = true;
    protected CLCommand m_parent = this;
    protected String m_description = null;
    protected String m_detailedDescription = null;
    protected boolean m_topLevel = false;
    protected boolean m_ignoreCase = false;
    protected boolean m_fixedPosition = true;
    protected String m_label = null;
    protected boolean m_hidden;

    public boolean isValid(List<String> clTokens) throws InvalidCLException {
        return this.isValid(clTokens, 0);
    }

    public boolean isValid(List<String> clTokens, int currentTokenIndex) throws InvalidCLException {
        boolean match = false;
        if (clTokens == null || clTokens.isEmpty()) {
            return false;
        }
        String token = clTokens.get(currentTokenIndex);
        if (!this.m_name.equals(token)) {
            return false;
        }
        clTokens.remove(currentTokenIndex);
        InvalidCLException clException = null;
        if (this.m_optionList == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_optionList.size()) {
            CLOption option;
            if ((option = this.m_optionList.get(i++)).isProcessed()) continue;
            ArrayList<String> clTokensCopy = new ArrayList<String>();
            clTokensCopy.addAll(clTokens);
            try {
                match = option.isValid(clTokensCopy, currentTokenIndex);
            }
            catch (InvalidCLException e) {
                clException = e;
                continue;
            }
            if (!match) continue;
            clException = null;
            clTokens.clear();
            clTokens.addAll(clTokensCopy);
            option.setProcessed(true);
            i = 0;
            if (!CLOptionSelection.CHOICE.equals((Object)this.m_selection)) continue;
            break;
        }
        if (!clTokens.isEmpty()) {
            if (clException != null) {
                throw clException;
            }
            throw new InvalidCLException(s_msgBundle.getMessage("3509", false, (Object[])new String[]{clTokens.get(0)}));
        }
        if (!match) {
            throw new InvalidCLException(s_msgBundle.getMessage("1001", false));
        }
        return true;
    }

    public CLOption getTopLevelOption(List<String> clTokens) {
        if (clTokens == null || clTokens.isEmpty()) {
            return null;
        }
        String token = clTokens.get(0);
        if (this.m_name != null) {
            if (this.m_name.equals(token)) {
                clTokens.remove(0);
            } else {
                return null;
            }
        }
        CLOption topLevelOption = null;
        ArrayList<String> clTokensCopy = null;
        for (int i = 0; i < this.m_optionList.size(); ++i) {
            CLOption option = this.m_optionList.get(i);
            if (option.getName() != null && !option.getName().equals(clTokens.get(0))) continue;
            if (option.isTopLevel()) {
                topLevelOption = option;
                break;
            }
            clTokensCopy = new ArrayList<String>();
            clTokensCopy.addAll(clTokens);
            topLevelOption = option.getTopLevelOption(clTokensCopy);
            if (topLevelOption != null) break;
        }
        return topLevelOption;
    }

    protected List<CLOption> getTopLevelOptions() {
        if (this.m_optionList == null) {
            return null;
        }
        ArrayList<CLOption> topOptionList = new ArrayList<CLOption>();
        Stack<CLOption> optionStack = new Stack<CLOption>();
        for (int i = this.m_optionList.size(); i > 0; --i) {
            optionStack.add(this.m_optionList.get(i - 1));
        }
        do {
            CLOption option;
            if ((option = (CLOption)optionStack.pop()).isTopLevel()) {
                topOptionList.add(option);
                continue;
            }
            if (option.getOptionList() == null || option.getOptionList().size() <= 0) continue;
            for (int i = option.getOptionList().size(); i > 0; --i) {
                optionStack.add(option.getOptionList().get(i - 1));
            }
        } while (!optionStack.isEmpty());
        return topOptionList;
    }

    protected List<CLOption> getAllOptions() {
        if (this.m_optionList == null) {
            return null;
        }
        ArrayList<CLOption> optionList = new ArrayList<CLOption>();
        ConcurrentLinkedQueue<CLOption> optionQueue = new ConcurrentLinkedQueue<CLOption>();
        optionQueue.addAll(this.m_optionList);
        do {
            CLOption option = (CLOption)optionQueue.remove();
            optionList.add(option);
            if (option.getOptionList() == null || option.getOptionList().size() <= 0) continue;
            optionQueue.addAll(option.getOptionList());
        } while (!optionQueue.isEmpty());
        return optionList;
    }

    public String getUsageText(String[] commandTokens) {
        ArrayList<String> clTokens = new ArrayList<String>();
        for (String token : commandTokens) {
            clTokens.add(token);
        }
        if (clTokens.size() > 1 && ((String)clTokens.get(1)).equals(CLSyntax2.STR_LIST)) {
            return this.getListText();
        }
        CLOption topLevelOption = this.getTopLevelOption(clTokens);
        if (topLevelOption != null) {
            return this.getDetailedHelp(topLevelOption);
        }
        return this.getHelpText();
    }

    public String getHelpText() {
        StringBuilder sb = new StringBuilder();
        List<CLOption> topLevelOptionList = this.getTopLevelOptions();
        if (topLevelOptionList == null) {
            return sb.toString();
        }
        if (this.getName().equals(CLSyntax2.STR_STAGE)) {
            sb.append(CLSyntax2.getUsageText_stage_usage());
        } else if (this.getName().equals(CLSyntax2.STR_COMPONENT)) {
            sb.append(CLSyntax2.getUsageText_comp_usage());
        }
        sb.append(CLSyntax2.LSEP + s_msgBundle.getMessage("3501", false, (Object[])new String[]{this.getLabel()}));
        sb.append(CLSyntax2.LSEP);
        for (CLOption option : topLevelOptionList) {
            if (option.isHidden()) continue;
            sb.append(this.getHelpText(option) + CLSyntax2.LSEP);
        }
        return sb.toString();
    }

    public String getHelpText(CLOption option) {
        return this.getHelpText(option, 0, "");
    }

    protected String getHelpText(CLOption option, int iteratorCount, String spacerString) {
        return option.getHelpText(option, iteratorCount++, spacerString);
    }

    protected String getDisplayString() {
        return "";
    }

    public String getDetailedHelp(CLOption topLevelOption) {
        ArrayList<String> processedOption;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHelpText(topLevelOption));
        if (topLevelOption.getOptionList() != null && topLevelOption.getOptionList().size() > 0) {
            processedOption = new ArrayList<String>();
            boolean first = true;
            for (CLOption option : topLevelOption.getAllOptions()) {
                if (processedOption.contains(option.getName())) continue;
                processedOption.add(option.getName());
                if (option.getDescription() == null) continue;
                if (!first) {
                    sb.append(CLSyntax2.LSEP);
                } else {
                    sb.append(CLSyntax2.LSEP);
                    sb.append(CLSyntax2.LSEP);
                    first = false;
                }
                String displayText = "";
                displayText = option.getLabel() != null ? "<" + option.getLabel() + "> " : option.getName() + " ";
                sb.append(displayText + option.getDescription());
            }
        }
        sb.append(CLSyntax2.LSEP + CLSyntax2.LSEP + CLSyntax2.DESCRIPTION_TEXT);
        sb.append(topLevelOption.getDetailedDescription());
        if (topLevelOption.getOptionList() != null && topLevelOption.getOptionList().size() > 0) {
            processedOption = new ArrayList();
            for (CLOption option : topLevelOption.getAllOptions()) {
                if (processedOption.contains(option.getName())) continue;
                processedOption.add(option.getName());
                if (option.getDetailedDescription() == null) continue;
                sb.append(" " + option.getDetailedDescription());
            }
        }
        sb.append(CLSyntax2.LSEP);
        return sb.toString();
    }

    public String getListText() {
        StringBuilder sb = new StringBuilder();
        List<CLOption> topLevelOptionList = this.getTopLevelOptions();
        if (topLevelOptionList == null) {
            return sb.toString();
        }
        if (this.getName().equals(CLSyntax2.STR_STAGE)) {
            sb.append(CLSyntax2.getUsageText_stage_usage());
        } else if (this.getName().equals(CLSyntax2.STR_COMPONENT)) {
            sb.append(CLSyntax2.getUsageText_comp_usage());
        }
        sb.append(CLSyntax2.LSEP);
        sb.append(s_msgBundle.getMessage("3500", false, (Object[])new String[]{this.getLabel()}) + CLSyntax2.LSEP);
        for (CLOption option : topLevelOptionList) {
            if (option.isHidden()) continue;
            String parents = "";
            for (CLCommand parent = option.getParent(); parent != this; parent = parent.getParent()) {
                if (parent.getName() == null) continue;
                parents = parent.getName() + " ";
            }
            String displayText = parents + option.getName();
            displayText = this.getPaddedString(displayText, 15);
            sb.append("      " + displayText + " : " + option.getDescription() + CLSyntax2.LSEP);
        }
        return sb.toString();
    }

    private String getPaddedString(String str, int length) {
        int strLength = 0;
        if (str != null) {
            strLength = str.length();
        }
        while (strLength++ < length) {
            str = str + " ";
        }
        return str;
    }

    public boolean isFixedPosition() {
        return this.m_fixedPosition;
    }

    public void setFixedPosition(boolean fixedPosition) {
        this.m_fixedPosition = fixedPosition;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDetailedDescription() {
        return this.m_detailedDescription;
    }

    public void setDetailedDescription(String detailedDescription) {
        this.m_detailedDescription = detailedDescription;
    }

    public CLCommand getParent() {
        return this.m_parent;
    }

    public void setParent(CLCommand parent) {
        this.m_parent = parent;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        String label = this.m_label;
        if ("ENUM".equalsIgnoreCase(this.getValueType())) {
            label = this.getValueListAsString();
        }
        return label;
    }

    public String getValueListAsString() {
        String label = "";
        if ("ENUM".equalsIgnoreCase(this.getValueType())) {
            boolean first = true;
            for (CLOptionEnumItem item : this.getValueList()) {
                if (item.isHidden()) continue;
                if (first) {
                    first = false;
                } else {
                    label = label + "|";
                }
                label = label + item.getText();
            }
        }
        return label;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public void setRequired(boolean mRequired) {
        this.m_required = mRequired;
    }

    public boolean isValueRequired() {
        return this.m_valueRequired;
    }

    public void setValueRequired(boolean valueRequired) {
        this.m_valueRequired = valueRequired;
    }

    public String getValueType() {
        return this.m_valueType;
    }

    public void setValueType(String mValueType) {
        this.m_valueType = mValueType;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getName(boolean navigateParent) {
        if (!navigateParent) {
            return this.getName();
        }
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.getParent().getName(navigateParent);
    }

    public void setSelection(CLOptionSelection selection) {
        this.m_selection = selection;
    }

    public CLOptionSelection getSelection() {
        return this.m_selection;
    }

    public List<CLOption> getOptionList() {
        return this.m_optionList;
    }

    public void setOptionList(List<CLOption> mOptionList) {
        this.m_optionList = mOptionList;
    }

    public void setValueList(List<CLOptionEnumItem> items) {
        this.m_valueList = items;
    }

    public List<CLOptionEnumItem> getValueList() {
        return this.m_valueList;
    }

    public String toString() {
        return "name=" + this.m_name;
    }

    public void setHidden(boolean hidden) {
        this.m_hidden = hidden;
    }

    public boolean isHidden() {
        return this.m_hidden;
    }

    public boolean isIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.m_ignoreCase = ignoreCase;
    }
}

